import unittest
from unittest.mock import MagicMock, patch
from hummingbird import Hummingbird, HummingbirdError
import json

class TestHummingbird(unittest.TestCase):

    @patch('serial.Serial')
    def setUp(self, mock_serial):
        self.mock_serial_instance = MagicMock()
        mock_serial.return_value = self.mock_serial_instance
        self.hb = Hummingbird(port="/dev/ttyMock")

    def test_on_success(self):
        self.mock_serial_instance.readline.return_value = b"OK\n"
        self.hb.on()
        self.mock_serial_instance.write.assert_called_with(b"on\n")

    def test_off_success(self):
        self.mock_serial_instance.readline.return_value = b"OK\n"
        self.hb.off()
        self.mock_serial_instance.write.assert_called_with(b"off\n")

    def test_status_json(self):
        status_data = {"state": "initializing", "warnings": []}
        self.mock_serial_instance.readline.return_value = f"OK {json.dumps(status_data)}\n".encode('ascii')
        result = self.hb.status()
        self.assertEqual(result, status_data)

    def test_on_query_true(self):
        self.mock_serial_instance.readline.return_value = b"OK true\n"
        self.assertTrue(self.hb.is_on())

    def test_on_query_false(self):
        self.mock_serial_instance.readline.return_value = b"OK false\n"
        self.assertFalse(self.hb.is_on())

    def test_fail_response(self):
        self.mock_serial_instance.readline.return_value = b"FAIL unknown command\n"
        with self.assertRaisesRegex(HummingbirdError, "unknown command"):
            self.hb._send_command("cmd")

    def test_no_response(self):
        self.mock_serial_instance.readline.return_value = b""
        with self.assertRaisesRegex(HummingbirdError, "No response"):
            self.hb.on()

if __name__ == '__main__':
    unittest.main()
